﻿using SnapsLibrary;

using Newtonsoft.Json;

class Ch10_06_JsonDemo
{
    class Contact
    {
        public string ContactName;
        public string ContactAddress;
        public string ContactPhone;
        public int ContactMinutesSpent;

        public Contact(string name, string address, string phone)
        {
            this.ContactName = name;
            this.ContactAddress = address;
            this.ContactPhone = phone;
            this.ContactMinutesSpent = 0;
        }
    }

    public void StartProgram()
    {
        SnapsEngine.SetTitleString("Demo Json");

        string name = SnapsEngine.ReadString("Wprowadź nazwę nowego kontaktu");
        string address = SnapsEngine.ReadMultiLineString("Wpisz adres kontaktu");
        string phone = SnapsEngine.ReadString("Wpisz telefon kontaktu");

        Contact newContact = new Contact(name: name, address: address, phone: phone);

        string json = JsonConvert.SerializeObject(newContact);

        SnapsEngine.DisplayString(json);

        SnapsEngine.WaitForButton("Wciśnij, aby deserializować");

        Contact contact = JsonConvert.DeserializeObject<Contact>(json);

        string resultString =
            "Nazwa: " + contact.ContactName + "\n" +
            "Adres: " + contact.ContactAddress + "\n" +
            "Telefon: " + contact.ContactPhone + "\n" +
            "Minuty: " + contact.ContactMinutesSpent.ToString();

        SnapsEngine.DisplayString(resultString);

    }
}
